package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification

class CoreSettingSpec extends Specification {
    private CoreSetting coreSetting

    def setup() {
        coreSetting = new CoreSetting()
    }

    def 'CoreSetting is enabled if patient history contains some non-whitespace text'() {
        when:
        coreSetting.patientHistoryRequired = patientHistoryRequired

        then:
        coreSetting.isEnabled() == enabled

        where:
        enabled | patientHistoryRequired
        false   | ''
        false   | null
        false   | ' '
        true    | 'Yes'
        true    | 'No'
    }
}
